
//+------------------------------------------------------------------+
//|                                    VT Support and Resistance.mq4 |
//|                                                 Copyright  2007 |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007"
#property link      ""

#property indicator_chart_window
#property indicator_color1 White
#property indicator_color2 Orange
#property indicator_color3 NULL
#property indicator_buffers 3

//---- input parameters

extern int Mode=0;
extern int LBP=10;


//---- buffers
int i;
double ResBuffer[];
double SupBuffer[];
double signalBuffer[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

  // IndicatorBuffers(2);
   SetIndexStyle(0,DRAW_ARROW,STYLE_DOT,1);
   SetIndexStyle(1,DRAW_ARROW,STYLE_DOT,1);
   SetIndexEmptyValue(2,0.0);

   SetIndexBuffer(0,ResBuffer);
   SetIndexBuffer(1,SupBuffer);
   SetIndexBuffer(2,signalBuffer);

   SetIndexArrow(0, 119);
   SetIndexArrow(1, 119);

   SetIndexLabel(0,"Resistance");
   SetIndexLabel(1,"Support");
   SetIndexLabel(2,"Signal");

   SetIndexDrawBegin(0,i-1);
   SetIndexDrawBegin(1,i-1);

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   
   int counted_bars=IndicatorCounted();
   if(counted_bars<0) counted_bars=0;
   if(counted_bars>0) counted_bars--;
   int limit=Bars-counted_bars;
   
        
        
   double maxHigh, maxLow;
   int pastIndex, counterHiLo;

   for(int i = limit ;i > 0 ;i--)
   { 
      SupBuffer[i] = 0;
      ResBuffer[i] = 0;
      signalBuffer[i]= 0;
      pastIndex=i+1;
      maxHigh=0;
      maxLow=0;
      counterHiLo=LBP;
      double movingAVG = iMA(Symbol(),0,LBP,0,Mode,PRICE_CLOSE,i);
      double movingAVGpast = iMA(Symbol(),0,LBP,0,Mode,PRICE_CLOSE,pastIndex);
      
      
      while (counterHiLo!=0)
      {
         if (High[i+counterHiLo]>maxHigh)
            maxHigh=High[i+counterHiLo];
         if (Low[i+counterHiLo]<maxLow || maxLow==0)
            maxLow=Low[i+counterHiLo];
         counterHiLo--;
      }
      
      if (movingAVG > Close[i] && movingAVGpast < Close[pastIndex])
         { ResBuffer[i] = maxHigh; signalBuffer[i]=maxHigh; }
      else
         { ResBuffer[i]=ResBuffer[i+1]; }
         
         
      if (movingAVG < Close[i] && movingAVGpast > Close[pastIndex])
         { SupBuffer[i] = maxLow; signalBuffer[i]=maxLow; }
      else 
         { SupBuffer[i]=SupBuffer[i+1]; }

}
//----

   return(0);
  }
//+------------------------------------------------------------------+



